package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Teg_chassis extends Teg_models
{
	public Teg_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Teg";
		name = getName();
		
		rID_blueprint = cars.cat_02.Teg:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_GREEN;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 6400;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.338;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_02.Teg:0x01D3r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_02.Teg:0x01E3r; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_02.Teg:0x00FBr; //Left exhaust
		parts_shop_big[1] = cars.cat_02.Teg:0x00FAr; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );
		
		float part_random;
		
		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.teg:0x000000D3r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000D4r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000D5r, "trunk", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000D6r, "FL door", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000D7r, "R seats", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000D9r, "FR door", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000DCr, "F windshield", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000DDr, "RR window", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000E0r, "RL window", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000E1r, "R windshield", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000E2r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000E3r, "R taillights", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000E4r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000E5r, "FR seat", actcolor, optical, power );
			if (power>=1.4)
				addPart( cars.cat_02.teg:0x000000FAr, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_02.teg:0x000000FBr, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D3r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D4r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D5r, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D6r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D7r, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D9r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000DCr, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000DDr, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000E0r, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000E1r, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000E2r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000E3r, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000E4r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000E5r, "FR seat", actcolor, optical, power );
			if (power>=1.4)
				if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000FAr, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000FBr, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D0r, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D1r, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D2r, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000D8r, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.teg:0x000000F1r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.teg:0x000000E7r, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000D0r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.teg:0x000000F3r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.teg:0x000000EAr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000D8r, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.teg:0x000000F2r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.teg:0x000000E8r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000D1r, "R bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.teg:0x000000F0r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.teg:0x000000E9r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000D2r, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.5 ) addPart( cars.cat_02.teg:0x000000F4r, "R wing 3", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000EBr, "R wing 2", actcolor, optical, power );

		}

		addPart( cars.cat_02.teg:0x000000F6r, "FR suspension" );
		addPart( cars.cat_02.teg:0x000000F7r, "FL suspension" );
		addPart( cars.cat_02.teg:0x000000F8r, "RR suspension" );
		addPart( cars.cat_02.teg:0x000000F9r, "RL suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // Speed 6 //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Star //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
				}
			} else                // Rotor //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
				}
			}
		}

		if ( power >= 1.666 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.333 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.666 ) // H&R aftermarket 36000 Nm 11"F 11"R //
		{
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
		} else
		if ( power >= 1.333 ) // stock 28000Nm 12" //
		{
			addPart( parts.running_gear:0x0000020Br, "spring" );
			addPart( parts.running_gear:0x0000020Br, "spring" );
			addPart( parts.running_gear:0x0000020Cr, "spring" );
			addPart( parts.running_gear:0x0000020Cr, "spring" );
		} else                // stock 23000Nm 14" //
		{
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
		}

		if ( power >= 1.666 ) // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		} else
		if ( power >= 1.333 ) // stock varied size 12.0"F 11.5"R //
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else                // stock universal 11.0"F 11.0"R //
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
		}

		if ( power >= 1.8 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else
		if ( power >= 1.3 ) // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else              // stock //
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.8 ) addPart( parts.engines.V6:0x00000008r, "4.0L V6 engine", actcolor, optical, (power-1.8)/0.2*2 ); else
		if ( power >= 1.6 ) addPart( parts.engines.V6:0x00000007r, "3.3L V6 engine", actcolor, optical, (power-1.6)/0.2*2 ); else
		if ( power >= 1.4 ) addPart( parts.engines.V6:0x00000060r, "2.8L V6 engine", actcolor, optical, (power-1.4)/0.2*2 ); else
		if ( power >= 1.2 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1.2)/0.2*2 ); else
		if ( power >= 1 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (power-1)/0.2*2 ); else
		if ( power >= 0.75 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (1-power)/0.25*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (0.75-power)/0.25*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.teg:0x000000CFr, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_02.teg:0x000000E6r, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_02.teg:0x000000F5r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_02.teg:0x000000CFr, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_02.Teg:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(1,0,1.0); //2WD all becomes FWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
